/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.MyListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import javax.swing.JComponent;

public class Slider
extends JComponent {
    private double begin;
    private int nbSteps;
    private double stepSize = 1.0;
    private int curPos = 0;
    private int mX;
    private int margeDroite;
    private int mY;
    private int Hp;
    private int W;
    private int H;
    boolean selected = false;
    boolean flagDrag = false;
    MyListener listener;

    public Slider(double begin, int nbSteps) {
        this.setOpaque(true);
        this.begin = begin;
        this.nbSteps = nbSteps;
        double sc = Aladin.getUIScale();
        this.mX = (int)(10.0 * sc);
        this.margeDroite = (int)(20.0 * sc);
        this.mY = 0;
        this.Hp = 0;
        this.H = this.Hp + this.mY + (int)(34.0 * sc);
        this.W = nbSteps + this.mX + this.margeDroite;
    }

    public Slider(double begin, int nbSteps, double stepSize) {
        this(begin, nbSteps);
        this.stepSize = stepSize;
    }

    public Slider() {
        this.W = this.nbSteps + this.mX + this.margeDroite;
    }

    public void setParams(double begin, int nbSteps, double stepSize) {
        this.begin = begin;
        this.nbSteps = nbSteps;
        this.stepSize = stepSize;
        this.W = nbSteps + this.mX + this.margeDroite;
    }

    public void setListener(MyListener listener) {
        this.listener = listener;
    }

    public void setPosition(int nbStepsFromStart, boolean callListener) {
        this.curPos = nbStepsFromStart;
        if (this.listener != null && callListener) {
            this.listener.fireStateChange(this.curPos + 1 + "");
        }
    }

    public void setPosition(int nbStepsFromStart) {
        this.setPosition(nbStepsFromStart, true);
    }

    public int getPosition() {
        return this.curPos;
    }

    public double getValue() {
        return this.begin + (double)this.curPos * this.stepSize;
    }

    protected void drawTriangle(Graphics g, int x) {
        int[] tx = new int[4];
        int[] ty = new int[4];
        tx[0] = tx[3] = x + this.mX;
        tx[1] = tx[0] - 7;
        tx[2] = tx[0] + 7;
        ty[0] = ty[3] = this.Hp + 14 + this.mY;
        ty[1] = ty[2] = ty[0] + 10;
        g.setColor(Color.blue);
        g.fillPolygon(tx, ty, tx.length);
        g.setColor(Color.black);
        g.drawPolygon(tx, ty, tx.length);
        g.setFont(Aladin.SPLAIN);
        double val = Slider.round(this.getValue(), 2);
        String valStr = Double.toString(val);
        int fontSize = g.getFontMetrics().stringWidth(valStr);
        int xStr = this.mX + x - fontSize / 2;
        if (xStr + fontSize > this.W) {
            xStr -= xStr + fontSize - this.W;
        }
        if (xStr < 0) {
            xStr = 0;
        }
        g.drawString(valStr, xStr, this.mY + this.Hp + 34);
        double leftVal = Slider.round(this.begin, 2);
        double rightVal = Slider.round(this.begin + (double)this.nbSteps * this.stepSize, 2);
        g.drawString(Double.toString(leftVal), 0, this.mY + this.Hp + 10);
        String rightValStr = Double.toString(rightVal);
        fontSize = g.getFontMetrics().stringWidth(rightValStr);
        xStr = this.nbSteps + this.mX + -fontSize / 2;
        if (xStr + fontSize > this.W) {
            xStr -= xStr + fontSize - this.W;
        }
        g.drawString(rightValStr, xStr, this.mY + this.Hp + 10);
    }

    @Override
    public Dimension preferredSize() {
        return new Dimension(this.W, this.H);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    @Override
    public boolean mouseMove(Event e, int x, int y) {
        int pos = this.getPosition();
        this.requestFocus();
        this.selected = (x -= this.mX) > pos - 5 && x < pos + 5;
        return true;
    }

    @Override
    public boolean mouseDown(Event e, int x, int y) {
        int pos = this.getPosition();
        this.selected = (x -= this.mX) > pos - 5 && x < pos + 5;
        return true;
    }

    @Override
    public boolean mouseDrag(Event e, int x, int y) {
        if (!this.selected) {
            return true;
        }
        if ((x -= this.mX) < 0) {
            x = 0;
        } else if (x > this.nbSteps) {
            x = this.nbSteps;
        }
        this.setPosition(x);
        this.flagDrag = true;
        this.repaint();
        return true;
    }

    @Override
    public boolean mouseUp(Event e, int x, int y) {
        if (!this.selected) {
            return true;
        }
        if ((x -= this.mX) < 0) {
            x = 0;
        } else if (x > this.nbSteps) {
            x = this.nbSteps;
        }
        this.setPosition(x);
        this.flagDrag = false;
        this.repaint();
        return true;
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(Color.black);
        g.drawLine(this.mX, this.Hp + this.mY + 13, this.mX + this.nbSteps, this.Hp + this.mY + 13);
        g.drawLine(this.mX, this.Hp + this.mY + 16, this.mX, this.Hp + this.mY + 10);
        g.drawLine(this.mX + this.nbSteps, this.Hp + this.mY + 16, this.mX + this.nbSteps, this.Hp + this.mY + 10);
        this.drawTriangle(g, this.getPosition());
    }

    @Override
    public boolean keyDown(Event e, int key) {
        int pos = this.getPosition();
        if (key == 1007) {
            if (pos < this.nbSteps) {
                this.setPosition(pos + 1);
            }
        } else if (key == 1006 && pos > 0) {
            this.setPosition(pos - 1);
        }
        this.repaint();
        return true;
    }

    public static double round(double d, int nbDec) {
        if (d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY) {
            return d;
        }
        double fact = Math.pow(10.0, nbDec);
        return (double)Math.round(d * fact) / fact;
    }
}

